package jamezo97.clonecraft.network;

import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.IModifiable;

import java.util.Map.Entry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.CCEntityClientPlayerMP;
import net.minecraft.client.entity.CCEntityOtherPlayerMP;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Handler16UpdateGenes extends Handler{

	@Value(id = 0)
	int entityId;
	@Value(id = 1)
	int[] values;
	@Value(id = 2)
	Gene[] genes;

	public Handler16UpdateGenes(EntityLivingBase entity, IModifiable mod) {
		this.entityId = entity.entityId;
		//		System.out.println("Load Handle 16: " + entityId);
		int length = mod.getGenePool().geneToLevel.size();
		values = new int[length];
		genes = new Gene[length];

		int index = 0;

		for(Entry<Gene, Integer> entry : mod.getGenePool().geneToLevel.entrySet()){
			values[index] = entry.getValue();

			genes[index] = entry.getKey();
			//			System.out.println("A:" + genes[index]);
			index++;
		}
		//		System.out.println("Updating " + index + " amount of genes for entity " + entityId);
	}

	public Handler16UpdateGenes() {

	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.CLIENT){
			handleClient(side, manager, player);
		}
	}

	@SideOnly(value = Side.CLIENT)
	public void handleClient(Side side, INetworkManager manager, EntityPlayer player){
		System.out.println("UPDATE GENES TO PLAYER: " + player + ", " + player.username);
		//		System.out.println("Handle 16: " + entityId);

		//		System.out.println("Loaded " + values.length + " amount of genes for entity " + entityId);
		Minecraft mc = Minecraft.getMinecraft();

		//		System.out.println(String.format("%s, %s", mc.thePlayer.entityId, ((WorldClient)player.worldObj).entityHashSet.lookup(entityId)));


		Entity e = this.getEntityOnSide(side, entityId, player.worldObj.provider.dimensionId);
		if(e != null){
			if(e instanceof EntityClientPlayerMP && !(e instanceof CCEntityClientPlayerMP)){
				e = CloneCraftUtils.convertPlayerToCustomized((EntityClientPlayerMP)e);
			}else if(e instanceof EntityOtherPlayerMP && !(e instanceof CCEntityOtherPlayerMP)){
				e = CloneCraftUtils.convertPlayerToCustomized((EntityOtherPlayerMP)e);
			}
			if(e instanceof IModifiable && e instanceof EntityLivingBase){
				EntityLivingBase entity = (EntityLivingBase)e;
				IModifiable mod = (IModifiable)e;
				mod.getGenePool().geneToLevel.clear();
				for(int a = 0; a < values.length; a++){
					mod.getGenePool().geneToLevel.put(genes[a], values[a]);
					//					System.out.println("B:" + genes[a]);
				}
			}
		}
	}

}
